/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.items.ItemBase;
import reliquary.items.MobCharmRegistry;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;

public class MobCharmFragmentItem
extends ItemBase {
    public MobCharmFragmentItem() {
        super(new Item.Properties());
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        for (String entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            items.add((Object)this.getStackFor(entityRegistryName));
        }
    }

    public ItemStack getStackFor(String entityRegistryName) {
        ItemStack ret = new ItemStack((ItemLike)this);
        NBTHelper.putString("entity", ret, entityRegistryName);
        return ret;
    }

    public static String getEntityRegistryName(ItemStack charm) {
        return NBTHelper.getString("entity", charm);
    }

    public static ResourceLocation getEntityEggRegistryName(ItemStack charm) {
        return new ResourceLocation(MobCharmFragmentItem.getEntityRegistryName(charm));
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(MobCharmFragmentItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return super.m_7626_(stack);
        }
        return new TextComponent(LanguageHelper.getLocalization(this.m_5524_(), entityType.m_20676_().getString()));
    }
}

